import request from 'supertest';
import { HttpStatus, INestApplication } from '@nestjs/common';
import { getPrivateApp, getSigners } from '../utils/setup';
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';

let signerWithAddress: SignerWithAddress[];
let app: INestApplication;

describe('data-access', () => {
  beforeAll(async () => {
    app = await getPrivateApp();
    signerWithAddress = await getSigners();
  });

  it(`/GET /list-cleared-items - Check if endpoint returns list of access tokens owned by user`, async () => {
    const response = await request(app.getHttpServer())
      .get('/tm/v1.0/list-cleared-items')
      .query({ tradingAccount: [signerWithAddress[1].address] });

    expect(response).toBeTruthy();
    expect(Array.isArray(response.body)).toBe(true);
    expect(response.statusCode).toBe(HttpStatus.OK);
  });
});
